package w83b.w83bOperacionesPaso.w83bActas;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bHistorialActaBean;
import w83b.w83bBeans.W83bImpugnacionesBean;
import w83b.w83bBeans.W83bIncidenciaActaBean;
import w83b.w83bBeans.W83bTramiteActaBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bCargarListasOutOPAction extends Q70ActionPasoOP{

	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//Guardamos la accion en el contexto
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String jJson = "";
		JSONObject resultado = new JSONObject ();	
		//docs adjuntos
		W83bActasBean acta=(W83bActasBean)contexto.get("w83bNuevaActaBean");
		JSONArray listaDocs=new JSONArray();
		JSONObject docJSON=new JSONObject();
		if(request.getParameter("accion").equals("documentos")){
			W83bDocBean doc=null;
//			HashMap datos=(HashMap)contexto.get("w83bMapaFileActas");
			for (int i=0;i<acta.getListaDocs().size();i++)
			{
				docJSON=new JSONObject();//NOPMD
				doc=(W83bDocBean)acta.getListaDocs().get(i);
				docJSON.put("nombreDoc", doc.getNombrePartido());
				docJSON.put("tipoDoc", doc.getTipoDocumento());
				docJSON.put("descTipo", doc.getDescTipo());
				docJSON.put("descFase", doc.getDescFase());
				docJSON.put("descTramite", doc.getDescTramite());
				docJSON.put("idDoc", doc.getId());
				if(StringUtils.isEmpty(doc.getNumeroRegistro())){
					docJSON.put("numRegistro", "");
				}
				else{
					docJSON.put("numRegistro", (doc.getNumeroRegistro().length()>8)? doc.getNumeroRegistro().substring(0, 8) + " " + doc.getNumeroRegistro().substring(8, doc.getNumeroRegistro().length()):doc.getNumeroRegistro());
				}
				if(StringUtils.isEmpty(doc.getFechaRegistro())){
					docJSON.put("fechaRegistro", "");
				}
				else{
					docJSON.put("fechaRegistro", doc.getFechaRegistro());
				}
				
				docJSON.put("usuario", doc.getUsuario());
				docJSON.put("codRemesaAcuse", StringUtils.isNotEmpty(doc.getCodRemesaAcuse())?doc.getCodRemesaAcuse():"");
				docJSON.put("codColeccionAcuse", StringUtils.isNotEmpty(doc.getCodColeccionAcuse())?doc.getCodColeccionAcuse():"");
				docJSON.put("codEnvioAcuse",StringUtils.isNotEmpty(doc.getCodEnvioAcuse())?doc.getCodEnvioAcuse():"");
				
				listaDocs.put(docJSON);

			}
			resultado.put("resultado", "ok");
			resultado.put("listaDocs",listaDocs);
			jJson=resultado.toString();
			
			
		}
		else if(request.getParameter("accion").equals("actasParciales")){
			W83bActasBean parcial=new W83bActasBean();
			parcial = (W83bActasBean)W83bUtilidadesComunes.inicializarPaginador(request, parcial);
			int num_paginas = (acta.getListaActasParciales().size()/Integer.parseInt(parcial.getTotal()));
			
			
			if(acta.getListaActasParciales().size()%Integer.parseInt(parcial.getTotal())>0){
				num_paginas++;
			}
			parcial.setRows(String.valueOf(num_paginas));
			
			List listaVariables = new ArrayList();
			listaVariables.add("numActa");
			listaVariables.add("numRegDefinitivo");
			listaVariables.add("fechaRegistroDefinitivo");
			listaVariables.add("numPreaviso");
			listaVariables.add("convenioTxt");
			listaVariables.add("fechaEntrada");
			listaVariables.add("fechaEleccion");
			listaVariables.add("fechaComision");
			listaVariables.add("fechaBaja");
			listaVariables.add("motivoBaja");
			listaVariables.add("electoresTotal");
			listaVariables.add("candidatosTotal");
			
			String varClave = null;
			
			
			jJson = W83bUtilidadesComunes.procesarTabla(acta.getListaActasParciales(),listaVariables,varClave,W83bActasBean.class, parcial);
			
			
			
			
			
		}
		else if(request.getParameter("accion").equals("impugnaciones")){
			/////
			W83bImpugnacionesBean impugnacionBean=new W83bImpugnacionesBean();
			impugnacionBean = (W83bImpugnacionesBean)W83bUtilidadesComunes.inicializarPaginador(request, impugnacionBean);
			int num_paginas = (acta.getListaImpugnaciones().size()/Integer.parseInt(impugnacionBean.getTotal()));
			
			
			if(acta.getListaImpugnaciones().size()%Integer.parseInt(impugnacionBean.getTotal())>0){
				num_paginas++;
			}
			impugnacionBean.setRows(String.valueOf(num_paginas));
			
			W83bActasBean actaTemp=(W83bActasBean)contexto.get("w83bDetalleActaTempBean");
			List listaImpugnaciones = new ArrayList();
			for(int i=0,size=acta.getListaImpugnaciones().size();i<size;i++){
				W83bImpugnacionesBean bean = new W83bImpugnacionesBean((W83bImpugnacionesBean)acta.getListaImpugnaciones().get(i));//NOPMD
				
				listaImpugnaciones.add(bean);
			}
			actaTemp.setListaImpugnaciones(listaImpugnaciones);
			contexto.set("w83bDetalleActaTempBean",actaTemp);
			
			
			List listaVariables = new ArrayList();
			listaVariables.add("num_impugnacion");	
			listaVariables.add("fecha_impugnacion");
			listaVariables.add("tipo");
			listaVariables.add("impugnante");
			listaVariables.add("sindicatos");
			listaVariables.add("dni_arbitro");
			listaVariables.add("nombre_arbitro");
			listaVariables.add("num_laudo");
			listaVariables.add("fech_laudo");
			listaVariables.add("fech_envio_juzgado");
			listaVariables.add("fech_sentencia");
			listaVariables.add("fech_baja_desest");
			
			String varClave = "num_impugnacion";
			
			
			jJson = W83bUtilidadesComunes.procesarTablaConId(acta.getListaImpugnaciones(),listaVariables,varClave,W83bImpugnacionesBean.class, impugnacionBean);
			
			
		}
		else if(request.getParameter("accion").equals("historial")){
			W83bHistorialActaBean historial=new W83bHistorialActaBean();
			historial = (W83bHistorialActaBean)W83bUtilidadesComunes.inicializarPaginador(request, historial);
			int num_paginas = (acta.getListaHistorial().size()/Integer.parseInt(historial.getTotal()));
			
			
			if(acta.getListaHistorial().size()%Integer.parseInt(historial.getTotal())>0){
				num_paginas++;
			}
			historial.setRows(String.valueOf(num_paginas));
			
			List listaVariables = new ArrayList();
			listaVariables.add("fecha_actuacion");
			listaVariables.add("descripcion");
			listaVariables.add("usuario");
			
			String varClave = null;
			
			
			jJson = W83bUtilidadesComunes.procesarTabla(acta.getListaHistorial(),listaVariables,varClave,W83bHistorialActaBean.class, historial);
		}
		else if(request.getParameter("accion").equals("tramitacion")){
			W83bTramiteActaBean tramite=new W83bTramiteActaBean();
			tramite = (W83bTramiteActaBean)W83bUtilidadesComunes.inicializarPaginador(request, tramite);
			int num_paginas = (acta.getListaTramitacion().size()/Integer.parseInt(tramite.getTotal()));
			
			
			if(acta.getListaTramitacion().size()%Integer.parseInt(tramite.getTotal())>0){
				num_paginas++;
			}
			tramite.setRows(String.valueOf(num_paginas));
			List listaVariables = new ArrayList();
			listaVariables.add("fase");
			listaVariables.add("desc_tramite");
			listaVariables.add("fecha_tramite");
			listaVariables.add("usuario_alta");
			listaVariables.add("fecha_alta");
			listaVariables.add("usuario_modif");
			listaVariables.add("fecha_modif");
			
			String varClave = null;
			
			
			jJson = W83bUtilidadesComunes.procesarTabla(acta.getListaTramitacion(),listaVariables,varClave,W83bTramiteActaBean.class, tramite);
			
		}
		else if(request.getParameter("accion").equals("incidencias")){
			W83bIncidenciaActaBean incidencia=new W83bIncidenciaActaBean();
			incidencia = (W83bIncidenciaActaBean)W83bUtilidadesComunes.inicializarPaginador(request, incidencia);
			int num_paginas = (acta.getListaIncidencias().size()/Integer.parseInt(incidencia.getTotal()));
			
			
			if(acta.getListaIncidencias().size()%Integer.parseInt(incidencia.getTotal())>0){
				num_paginas++;
			}
			incidencia.setRows(String.valueOf(num_paginas));
			
			List listaVariables = new ArrayList();
			listaVariables.add("numIncidencia");
			listaVariables.add("fecha");
			listaVariables.add("descripcion");
			listaVariables.add("dni");
			
			String varClave = "numIncidencia";
			
			
			jJson = W83bUtilidadesComunes.procesarTabla(acta.getListaIncidencias(),listaVariables,varClave,W83bIncidenciaActaBean.class, incidencia);
			
			
		}
		response.setContentType("text/javascript;charset=iso-8859-1");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		response.setStatus(HttpServletResponse.SC_OK);
		PrintWriter out = response.getWriter();
		out.print(jJson);
		out.flush();
		
		return null;

				
		
		
	}
}
